# Manajemen Domain IT Solution

Aplikasi Laravel modern untuk mengelola domain DNS dan nameserver, dibangun dengan [Livewire Volt](https://volt.laravel.com/) dan [Flux](https://flux.laravel.com/).

---

## Fitur

- Autentikasi pengguna
- Tambah, edit, dan hapus domain
- Tambah, edit, dan hapus maksimal 3 nameserver per domain
- Pencarian dan paginasi untuk domain
- Dashboard dengan statistik informatif
- Antarmuka responsif dan ramah pengguna (Tailwind CSS + Flux)
- Backend aman dan RESTful

---

## Memulai

### Prasyarat

- PHP 8.2+
- Composer
- Node.js (disarankan v18+)
- npm

### Instalasi

```bash
git clone https://github.com/yourusername/nameserver-app.git
cd nameserver-app
composer install
cp .env.example .env
php artisan key:generate
php artisan migrate
npm install
```

### Menjalankan Aplikasi

```bash
npm run dev
php artisan serve
```

Buka [http://localhost:8000](http://localhost:8000) di browser Anda.

---

## Penggunaan

- Daftar dan login.
- Tambahkan domain dan kelola nameserver (maksimal 3 per domain).
- Gunakan dashboard untuk melihat statistik dan aktivitas terbaru.

---

## Pengembangan

- **Frontend:** Tailwind CSS, Vite, Flux UI
- **Backend:** Laravel 12, Livewire Volt

### Perintah Penting

- `npm run dev` — Menjalankan server frontend untuk pengembangan
- `php artisan serve` — Menjalankan server backend Laravel
- `php artisan migrate` — Menjalankan migrasi database

---

## Kontribusi

Kontribusi sangat terbuka! Silakan buat issue atau pull request.

---

## Lisensi

Proyek ini dilisensikan di bawah MIT License.
