<?php

namespace App\Http\Controllers;

use App\Models\NameServer;
use Illuminate\Http\Request;

class NameServerController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $nameServers = NameServer::with('domain')->get();

        return view('nameServers.index', compact('nameServers'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('nameServers.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'domain_id' => 'required|exists:domains,id',
            'host' => 'required|max:255',
        ]);

        NameServer::create([
            'domain_id' => $request->domain_id,
            'host' => $request->host,
        ]);

        return redirect()->route('nameServers.index')->with('success', 'Name Server created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(NameServer $nameServer)
    {
        $nameServer->load('domain');

        return view('nameServers.show', compact('nameServer'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(NameServer $nameServer)
    {
        $nameServer->load('domain');

        return view('nameServers.edit', compact('nameServer'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, NameServer $nameServer)
    {
        $request->validate([
            'domain_id' => 'required|exists:domains,id',
            'host' => 'required|max:255',
        ]);

        $nameServer->update([
            'domain_id' => $request->domain_id,
            'host' => $request->host,
        ]);

        return redirect()->route('nameServers.index')->with('success', 'Name Server updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(NameServer $nameServer)
    {
        $nameServer->delete();

        return redirect()->route('nameServers.index')->with('success', 'Name Server deleted successfully.');
    }
}
